---
abstract: 11月1日，在榕汇·企业服务CEO闭门会上，高瓴资本运营合伙人、前美团COO干嘉伟，从To B业务的基本思考框架出发，围绕To B销售的组织建设、团队管理等问题做了深度分享。其中既有回归商业和人性本质的思考，也有非常务实具体的实操指南。
content: '![](/static/img/ganjiawei2_191107.jpg)


  To B销售在今天面临着更大的挑战：更激烈的竞争、更强势的客户、更难取得的共识、更难管理的团队...如何锻造一支能打的To B销售铁军？如何找到增长路径并规模化复制？如何搭建销售组织？是自营还是渠道？是外部引进人才还是内部培养？


  干嘉伟被认为是中国最懂To B销售的人之一。作为阿里巴巴第67号员工，干嘉伟是“中供铁军”代表性人物，后加入美团担任COO，亲手打造了美团的线下地推铁军。


  11月1日，在榕汇·企业服务CEO闭门会上，高瓴资本运营合伙人、前美团COO干嘉伟，从To B业务的基本思考框架出发，围绕To B销售的组织建设、团队管理等问题做了深度分享。其中既有回归商业和人性本质的思考，也有非常务实具体的实操指南。


  在干嘉伟看来，“很多方法不是别人不知道，只是你比别人更坚持、更用心。”例如，干嘉伟在分享中反复提及的“早启动晚分享”，就是其在美团带领万人销售团队时非常重视抓的基本方法。也成为高榕投资企业CEO们会后反馈要立刻践行到日常管理中的关键一点。


  以下是他的分享：


  坦白说，这次在榕汇分享，是我目前为止准备时间最长的一次。一是大家会前提问很踊跃；二是虽然都围绕To B业务，但实际上大B、小B切入点很不一样，所以花了大量时间思考如何在有限的时间里尽可能把观点分享出来，也希望能更有针对性。


  ## 一、To B业务的基本思考框架


  当我们在谈论To B业务时，首先要有一套基本的思考框架。其中最核心、最基本的三个要素是——潜在客户数、客户分布和定价。相反，在谈论To B业务时，单纯地谈“大客户”和“中小客户”意义不大，因为每个人对大小的定义不同。你眼中的大客户，对别人来说可能是小客户。


  **1、潜在客户数**


  做To B业务，首先要思考你切的市场有多少潜在客户数。如果你的潜在客户数是三位数或者勉强跑到四位数，市场规模可想而知。假设有1000家潜在客户，单个客户年营收100万很多了，那么最大是10亿的市场。而且一家客户年营收100万意味着什么？意味着有很大的不确定性。


  对比来看，美团的客户数保守说有1000万，每家客户年营收1万，那也有1000亿的市场规模，客户的可控性也高得多。


  潜在客户数是决定你的生意是否有地位、是否安全、是否可控的重要因素。


  **2、客户分布**


  即你的客户以什么样的密度在分布着。以阿里和美团的客户分布情况来对比。原来我在阿里，大量客户是开发区里的制造型企业，客户之间的平均距离是2-3公里，阿里一位成熟的销售人员可以覆盖和服务的客户数是50-70家。而美团2016年每位销售可以覆盖的客户数达到了250家。


  阿里与美团的IT系统、管理水平是差不多的，那效率的差异是什么导致的？是客户分布导致的。因为美团的业务是本地生活，客户集中分布在市内，一个mall进去可能就有20家客户。


  所以，你的客户分布情况如何，例如是否有明显的聚集效应、是全国平均分布还是有较强的地域性，都决定了作业模式和销售组织的设计。


  而中国之所以出现地推这个行业，是因为中国潜在客户数绝对值大、分布密度又高，地推模式使销售的有效作业时间可以最大化。直销这个行业的核心价值就在于与客户有效接触的时间。


  **3、定价**


  定价非常重要，定价要从很多角度来看。一方面，定价不是越高越好，因为高定价会对招聘、培训、标准化、规模化扩张、客户回款周期等带来不利影响；定价肯定也不是越低越好，因为有些产品对客户而言，收1万不见得比收4万要快，而且定价高可以提供更好的服务、让客户更满意。


  To B业务的定价其实不能用传统的经济学视角来分析。To B业务既不是按照成本来定价，也不是根据竞争定价。To B业务的定价要与你的潜在客户数、客户分布相匹配，定价既要能够保证合理的销售速度，又要有足够的利润流向销售渠道。


  每位销售人员每年带来100万的营收，是一个比较好的参考标准。平均拿出25万给到销售，剩下的75万可以投入做产品研发、做客户服务，公司还有利润，To B就是这么一门生意。


  总结一下，思考To B业务的基本逻辑框架是：你切入了一个怎样的市场，这个市场规模有多大；客户分布决定了销售效率，决定了一位销售能覆盖多少客户；定价既要保证合理的销售速度，也要为销售渠道提供足够的利润。


  ## 二、如何找到业务规模化扩张路径


  做To B业务，经常有人问这样的问题：增长遇到瓶颈怎么办？总部所在城市增长快，其他城市增长慢怎么办？我认为，这些问题的本质是没有找到业务规模化扩张的路径。


  2011年11月，我刚去到美团，正是“千团大战”最激烈的时候，作为COO我负责的是供应链、销售和增长。但最初几个月，我并没有做具体的管理工作，而是到处去问一线人员和中高层管理人员：在美团如何成为一名销冠？


  我当时的逻辑是，如果可以找到可复制的成为销冠的路径，就通过管理把其他人复制成销冠。当时美团有一千多人，一定有牛人；只要找到那个人，其他人都来学习他就可以了，这就是管理。


  那么如何成为一名销冠？当时我收集到各种各样的答案，有人说是勤奋，有人说是脸皮厚，比较多的一个说法是“消费感好”。所谓消费感好，意思是团购套餐要卖爆，需要销售懂得搭配一个好的套餐。但消费感很难量化和定义，不可规模复制。我怎么培训员工呢？不可能让他们上班就去下馆子，不现实。


  最后我们发现，与业绩相关系数最高的是什么？就是供给数，说白了就是团购单量。


  2012年美团开年会的时候，我和同事说，2012年我们就做一件事——“狂拜访、狂上单”。


  对于大规模团队的销售而言，需要足够简单，不要绕弯子。“狂拜访、狂上单”这6个字很明确，关键动作（拜访）和结果指标（上单）都有了，态度也有了，就是“狂”。“狂”这个字很有画面感，玩命、拼命、猛，都不如“狂”。


  经过一年时间，美团就把竞争对手远远甩在后面。


  我在美团期间，也没有按行业划分销售人员，而是要求“见门就进”，因为直销真正的专业度就是拜访量，行业的差异性不是壁垒。


  小结一下，当时美团先找到了与最终业绩相关系数最高的指标——供给，再通过“狂拜访、狂上单”提高供给数，从而找到了业务规模化扩张的路径。


  ![](/static/img/ganjiawei4_191107.jpg)


  ## 三、To B销售组织两个关键问题


  **1、自营VS渠道？**


  1）早期自营打样


  很多创业公司关注一个问题，销售是自营还是找渠道合作。我对初创公司的建议是，早期老老实实自营打样，真正知道销售效率如何，过程中也能了解客户的真正需求。


  对于渠道商，创业公司不要心存不切实际的幻想，花了很多力气在条款和YY上，最后发现渠道商没有认真帮你销售。原因很简单，因为渠道本质上就是要挣钱，不可能因为你是创业公司、很有前途，就和你“共度时艰”。


  2）打磨期、非标、低毛利产品慎用渠道


  产品打磨期，尚未完全了解市场的真正需求，产品也要经常调整，这时候交给渠道商，对双方而言风险都很大。


  非标就是指以前市场上没有出现过同类产品和服务，不能指望代理商帮你趟出一条路。


  低毛利产品，需要很高的管理水平和效率才有可能是赚钱的生意，渠道商亏钱、你亏得更多。


  实际上，这些事情在“千团大战”的时候都发生过。当时团购还不挣钱，有团购公司想：自己扩张需要快速招销售，招完还要培训，培训完也不一定挣钱，既然这样不如找代理。但实际上代理并不会去真正帮你趟路子，权利和义务都是对等的。所以2011、2012两年，我在美团最大的价值就是跟王兴说，我们啥也别干，就做自营。


  **2、如何设计提成制度**


  有关To B销售提成制度的设计，有3点基本框架。


  1）目标薪酬


  什么是目标薪酬？和你公司本身的情况没有关系，要看所在国家、地区、城市、该行业同类岗位的社会均值收入，这与地方房价、物价、工作性质等密切相关。


  制定目标薪酬时首先需要考虑的问题是，在某地、做某一工作，多少钱的薪资是有竞争力的，这是目标薪酬。


  2）固浮比


  固浮比，指的是底薪与提成的比例。对于创业公司而言，固浮比越低、成本越低；但固浮比太低招不到人，要设计在一个合理的水平。较低的固浮比可以让好坏差距拉大，刺激管理杠杆。


  回过头看，管理和组织的杠杆是什么？如果能把平均50分的组织，通过管理、系统提升和产品封装迅速提升到80分，中间30分就是企业创造的价值，就是能够赚钱的地方。


  3）费比


  费比是指销售和渠道成本占全部营收的比重。没有所谓合理的费比，只能逐步改善、永无止境地去追求。从亏钱，到赚钱，再到巨赚，把多出的钱投入到流量、技术、品牌等等。


  美团最开始不赚钱，2012年“狂拜访、狂上单”，一年降了4次销售提成。当时团队怨声载道，但费比降低后，多出来的钱可以用于买流量，买了更多流量后销量就更高，之后有了更大的市场影响力、能拿到更好的供给、要求更高的毛利。销量增加之后，尽管提成下降，但两项相乘，销售人员的总体收入上升，这就是良性循环。


  对于创业公司而言，“354”更有意义，即3个人干5个人的活拿4个人的钱。需要付出比同行更多，但是如果能达到要求，就可以拿到有足够尊严的收入。而且经过这样的训练，以后在市场上的身价不一样。


  ## 四、突破To B销售管理天花板


  **1、如何突破销售管理人员的瓶颈**


  很多人问有关销售管理人员的问题，包括销售管理人员是外部招聘还是内部培养，具备哪些特点算是优秀的销售管理干部，如何培训销售管理人员，等等。


  1）难度和规模决定平均管理水平


  首先要明确一点，是销售管理的难度和规模决定了平均管理水平。


  什么是销售管理的难度？以电销和直销（地推）为例对比，电销的管理难度就比直销低。电销的呼叫中心是相对标准化的，相对更易管理，销售水平偏差不会太多，分布呈纺锤状；直销销售上班就出去跑客户了，管理起来更难，而且销售好坏差别非常大，分布呈金字塔状。


  销售管理的规模也决定了管理水平。就像好的技术人员都是在大数据、高并发的情况下训练出来的，销售也是一样。市场上大部分的销售，所面对的潜在客户数都是两位数、三位数，上四位数的很少；活动半径也多在本市、本省，很少遍及全国。而当客户数达到了五位数、六位数，玩法完全不同。规模差距，决定了作业模式和管理水平根本上的差异。


  2）核心组织能力自建


  再来谈销售管理人员是外部引进还是内部培养，我的答案是都要有，但有优先级。


  如果你的潜在客户数是五位数、六位数，那么市场上99%的销售满足不了你的诉求，内部也很难培养，必须要外部引进。从哪引进？目前中国To B行业销售相对得到验证和认可的三家公司——中大企业华为毫无疑问是No.1，中小企业是阿里和美团。


  此外，人才要自上而下引进，不要从中间引进，方法论才适用整个公司，不会出现打架的情况。而且这个人一般都有曾经熟悉的同事，可以变成今天的战友。


  除了外部引进，核心组织能力自建也非常重要。有哪些办法？


  以下这几点很简单，但是非常管用。美团到店餐饮最多时候有15000名地推人员，就做了这几件事。如果做到位，美团的80分肯定到了。


  A.师徒制


  如何培养潜在的管理人员？师徒制是一种很好的方式。新人进来除了主管，还有一位师父。第一有利于新人“活下来”，第二可以通过带徒弟的方式，观察师父是否有潜质成为管理人员。


  B.M0（潜在管理人员）


  如果这位师父“带活”了两个徒弟，说明有潜质，可以成为潜在管理人员，就是我们说的M0。平时可以参与一些管理工作，等到真正做管理的时候，不至于手忙脚乱。这个道理很简单。


  C.早启动晚分享


  这一点非常重要。如果销售管理整天琢磨培训、找一位厉害的培训总监，那都是“神秘力量依赖症”。县官不如现管，“早启动晚分享”才是真正靠谱的培训。


  每天下班前，主管把大家聚在一起，每个人分别分享一个亮点和一个可以改善的地方，这种方法比任何培训都好。2015年我在美团，每晚要求看到城市经理发来的亮点总结，这种压力会层层传导下去。这件事是反人性的，必须抓。


  **2、销售团队基本管理问题**


  1）销售团队的培养和建设


  今天谈销售团队管理，有人会说90后、00后队伍难带了。但其实每个时代都有每个时代的问题；关键是时代在变，人性是不变的。对照马斯洛人类需求的五个层次，可能今天90后、00后的生理和安全需求可以被满足，但还会有自我实现的需求，这是不变的。


  管理不要刻舟求剑，管理就是和人打交道，要去理解人性。然后用制度去遏制人性恶的一面，激发人性好的一面。


  2）老销售懈怠


  有CEO问，公司工作时间长的老销售出现懈怠怎么办。这里也有一个基本的思考方向，即人均客户数一定会达到一个动态平衡点。一位销售一边开发新客户，一边服务和维护老客户，当老客户有一定流失，需要再花精力开发新客户，最终达到一个数值。


  而这个动态平衡点，取决于客户数规模、客户分布、IT和管理水平。如果一家公司的动态平衡点是100家客户，而老销售服务的客户数已经达到了110家，就不用再折腾了；如果只有50家，没有达到平衡点、“未老先衰”，那就需要从管理和佣金设计两头使劲。比如压低老客户订单的提成。


  3）销售培训


  销售培训，主要是靠直接的管理人员，不要依赖培训团队。大家回想一下战争片，平时思想工作都是班长和老兵在做。


  和依赖培训类似，销售管理做得不到位、业务没做好，一些公司还会依赖市场部、依赖GR、依赖企业文化，这些都是“神秘力量依赖症”。


  To B的销售是什么？一个好的销售人员在客户那里，他就代表了公司、代表了CEO，他既是销售部，又是客服部、市场部，还是一个形象大使。


  如何让销售人员做到这些？还是我刚才讲的，做好“早启动晚分享”和师徒制。很多方法不是别人不知道，只是你比别人更坚持、更用心。


  4）矩阵式管理


  也有To B公司采用矩阵式管理，即在总部设立各事业部，在各区域设分公司。我的建议是，创业公司不要轻易玩矩阵式管理。内部会面临趋利避害的人性，导致不同条线按照自己利益最大化去操作；外部则会面临竞争压力，分散后可能会面对不同的竞争对手。


  矩阵式管理需要很成熟的企业去运作，需要有很好的系统、很好的管理文化和协同机制。创业公司还是要先做端到端的闭环。当下可能牺牲了一部分协同效应，但是要“先占市场，再拧毛巾”。


  ![](/static/img/ganjiawei1_191107.jpg)'
createDate: 2019-11-07 11:07:00+00:00
pic: /static/img/abstract_ganjiawei_191107.jpg
title: 干嘉伟：To B销售要回归本质，不要有“神秘力量依赖症”
type: 榕汇
...
